#include "softi2c.h"
#include <xc.h>
#include "util.h"

//write only:

//Writes a bit to the soft I2C port
void I2Cbit(unsigned char n){      //send one bit
    if(n){
        SDAHI
    }else{
        SDALO
    }
    SCLHI
    SCLLO
}


//Writes a byte to the i2c
//CAUTION This code has the PGA231 CS line hard coded into the ASSERT_CS and DEASSERT_CS macro
void I2Cbyte(unsigned char n){     //send byte,return read byte + ACK
    ASSERT_CS
    I2Cbit(n&128);
    I2Cbit(n& 64);
    I2Cbit(n& 32);
    I2Cbit(n& 16);
    I2Cbit(n&  8);
    I2Cbit(n&  4);
    I2Cbit(n&  2);
    I2Cbit(n&  1);
//    I2Cbit(1);  //ack bit - nor used by the PGA2311 
    DEASSERT_CS
}



//Writes a word to the PGA2311 - which is two bytes for R and then L volume
//CAUTION This code has the PGA231 CS line hard coded into the ASSERT_CS and DEASSERT_CS macro
void I2C_Volume_Word(unsigned char n){     //send byte,return read byte + ACK
    ASSERT_CS
    I2Cbit(n&128);
    I2Cbit(n& 64);
    I2Cbit(n& 32);
    I2Cbit(n& 16);
    I2Cbit(n&  8);
    I2Cbit(n&  4);
    I2Cbit(n&  2);
    I2Cbit(n&  1);
    I2Cbit(n&128);
    I2Cbit(n& 64);
    I2Cbit(n& 32);
    I2Cbit(n& 16);
    I2Cbit(n&  8);
    I2Cbit(n&  4);
    I2Cbit(n&  2);
    I2Cbit(n&  1);
    //    I2Cbit(1);  //ack bit - nor used by the PGA2311
    DEASSERT_CS
}



void I2Cstart(void){                 //send start condition
    SDALO
    SCLLO
    ASSERT_CS
}

void I2Cstop(void){                  //send stop condition
    DEASSERT_CS
    SDALO
    SCLHI
    SDAHI
}
